import sys

target = sys.argv[1]
n = int(sys.argv[2])

output = open('script.sh', 'w')
for i in range(n):
    script_name = "script_%s_%d.sh" % (target, i)
    handle = open(script_name, 'w')
    handle.write("""\
#!/bin/bash
#SBATCH -e ./script_%s_%d.stderr
#SBATCH -o ./script_%s_%d.stdout
#SBATCH --mem=4G
python remove_mapped_sequences.py %s %d
""" % (target, i, target, i, target, i))
    handle.close()
    output.write('sbatch %s\n' % script_name)

output.close()
print("Scripts generated; run script.sh to schedule them on Grid Engine")
